using System;
using System.IO;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using DynaPDF;

namespace examples
{
	class Class1
	{
      [DllImport("gdi32.dll", CharSet=CharSet.Auto)] private static extern IntPtr CreateDC(String lpszDriver, String lpszDevice, IntPtr lpszOutput, IntPtr lpInitData);
      [DllImport("gdi32.dll", CharSet=CharSet.Ansi)] private static extern int DeleteDC(IntPtr hdc);

      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

      static IntPtr GetPrinterDC()
      {
         PrintDialog d = new PrintDialog();
         d.AllowCurrentPage = false;
         d.AllowPrintToFile = false;
         d.AllowSelection   = false;
         d.AllowSomePages   = false;
         d.UseEXDialog      = true; // Required in 64 bit apps
         if (d.ShowDialog() == DialogResult.OK)
         {
            return CreateDC(null, d.PrinterSettings.PrinterName, IntPtr.Zero, IntPtr.Zero);
         }
         return IntPtr.Zero;
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            // Import anything and don't convert pages to templates
            pdf.SetImportFlags(TImportFlags.ifImportAll | TImportFlags.ifImportAsPage);
            if (pdf.OpenImportFile("../../../../../dynapdf_help.pdf", TPwdType.ptOpen, null) < 0)
            {
               pdf = null;
               return;
            }
            // We print only the first page in this example.
            pdf.EditPage(1);
               pdf.ImportPageEx(1, 1.0, 1.0);
            pdf.EndPage();

            // If the file contains layers then ApplyAppEvent() makes sure that the same result will be printed
            // that Adobe's Acrobat would print. However, you can also print the view or export state if you want.
            // The help file doesn't contain layers and this command does just nothing but in a real world
            // application ApplyAppEvent() should be called.
            pdf.ApplyAppEvent(TOCAppEvent.aePrint, false);

            IntPtr dc;
            if ((dc = GetPrinterDC()) != IntPtr.Zero)
            {
               TRectL margin = new TRectL();
               if (pdf.PrintPDFFile(null, "Test Print", dc, TPDFPrintFlags.pffDefault | TPDFPrintFlags.pffAutoRotateAndCenter | TPDFPrintFlags.pffShrinkToPrintArea, ref margin))
                  Console.Write("Page 1 successfully printed\n");

               DeleteDC(dc);
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
